#pragma once

#include <yamail/expected.h>
#include <macs/types.h>
#include <mail_getter/AttachShieldCrypto.h>
#include <yamail/data/reflection/details/adt.h>
#include <mail/hound/include/internal/server/base.h>
#include <mail/hound/include/internal/wmi/errors.h>


BOOST_FUSION_DEFINE_STRUCT((hound)(server)(handlers)(v2)(attach_sid), Request,
    (macs::Uid, uid)
    (macs::Mid, mid)
    (std::vector<macs::Hid>, hids)
)

namespace hound::server::handlers::v2::attach_sid {

using mail_errors::error_code;
using Response = std::unordered_map<std::string, std::string>;

template<typename AttachSidPacker>
struct Method {
    static constexpr auto MULTIPLE_PART_KEY = "all";

    AttachSidPacker attachShield;

    yamail::expected<Response> operator() (const Request& args) const {
        const auto& [uid, mid, hids] = args;

        if (uid.empty() || mid.empty() || hids.empty()) {
            return yamail::make_unexpected(error_code{libwmi::error::invalidArgument, "one of arguments is empty (uid, mid, hids)"});
        }

        const auto applyShield = [this](auto part) -> std::string
        {
            const std::string packedData = attachShield(std::move(part));
            return encode_url(packedData);
        };

        Response resp;

        using namespace mail_getter::part_id;
        if (hids.size() > 1) {
            resp.reserve(1 + hids.size());
            resp[MULTIPLE_PART_KEY] = applyShield(MultipleMessagePart{uid, mid, hids});
        }

        std::transform(hids.begin(), hids.end(), std::inserter(resp, resp.end()),
                       [&](const auto& hid) -> Response::value_type {
            return {hid, applyShield(SingleMessagePart{args.uid, args.mid, hid})};
        });

        return resp;
    }
};

}
