#pragma once

#include <mail/hound/include/internal/server/base.h>


namespace hound::server::handlers::v2::attach_sid {

class Handler final: public Base {
public:
    explicit Handler(ConfigPtr config)
            : Base{std::move(config)} {
    }

    inline bool isAccepted(ymod_webserver::methods::http_method method) const final {
        return ymod_webserver::methods::mth_get == method;
    }

private:
    void execute(RequestPtr r, boost::asio::yield_context /*yield*/) const final;
};

} // namespace hound::server::handlers::v2::attach_sid
