#pragma once

#include <macs/envelope.h>
#include <mail/hound/include/internal/v2/folders/folder_reflection.h>
#include <mail/hound/include/internal/v2/tabs/tab_reflection.h>
#include <mail/hound/include/internal/v2/messages/reflection.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/email.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/labels.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/folders.h>

namespace hound::v2::changes::delta {

template <typename T>
using Tag = typename std::decay_t<T>::Tag;

template <typename T>
using Value = decltype(std::declval<T>().value);

template <typename T>
constexpr auto tag(T&&) { return Tag<T>::value; }

template <typename T>
constexpr auto value(T&& v) -> decltype((v.value)) {
    return v.value;
}

template <typename T>
constexpr auto empty(const T& v) ->
        std::enable_if_t<!std::is_void<decltype(value(v))>::value, bool> {
    return boost::empty(value(v));
}


struct ApiTag;

template <typename T>
using AdtView = yamail::data::reflection::AdtView<T, ApiTag>;

using Envelope = hound::server::handlers::v2::messages::Envelope;

using Label = AdtView<macs::Label>;

using Folder = hound::server::handlers::v2::folders::Folder;

using Tab = hound::server::handlers::v2::tabs::Tab;

struct Store {
    std::vector<Envelope> value;
    struct Tag { constexpr static const char* value = "store";};
};

struct Update {
    struct Item {
        macs::Mid mid;
        std::vector<macs::Lid> labels;
    };
    std::vector<Item> value;
    struct Tag { constexpr static const char* value = "update";};
};

struct Delete {
    std::vector<macs::Mid> value;
    struct Tag { constexpr static const char* value = "delete";};
};

struct Copy {
    std::vector<Envelope> value;
    struct Tag { constexpr static const char* value = "copy";};
};

struct Move {
    struct Item {
        macs::Mid mid;
        macs::Fid fid;
        boost::optional<macs::Tid> tid;
        std::vector<macs::Lid> labels;
    };
    std::vector<Item> value;
    struct Tag { constexpr static const char* value = "move";};
};

struct QuickSave {
    std::vector<Envelope> value;
    struct Tag { constexpr static const char* value = "quick-save";};
};

struct ThreadsJoin {
    struct Item {
        macs::Mid mid;
        macs::Tid tid;
        std::vector<macs::Lid> labels;
    };
    std::vector<Item> value;
    struct Tag { constexpr static const char* value = "threads-join";};
};

struct LabelCreate {
    std::vector<Label> value;
    struct Tag { constexpr static const char* value = "label-create";};
};

struct LabelDelete {
    std::vector<macs::Lid> value;
    struct Tag { constexpr static const char* value = "label-delete";};
};

struct LabelModify {
    std::vector<Label> value;
    struct Tag { constexpr static const char* value = "label-modify";};
};

struct FolderCreate {
    std::vector<Folder> value;
    struct Tag { constexpr static const char* value = "folder-create";};
};

struct FolderDelete {
    std::vector<macs::Fid> value;
    struct Tag { constexpr static const char* value = "folder-delete";};
};

struct FolderModify {
    std::vector<Folder> value;
    struct Tag { constexpr static const char* value = "folder-modify";};
};

struct TabCreate {
    std::vector<Tab> value;
    struct Tag { constexpr static const char* value = "tab-create";};
};

struct MoveToTab {
    struct Item {
        macs::Mid mid;
        std::string tab;
    };
    std::vector<Item> value;
    struct Tag { constexpr static const char* value = "move-to-tab";};
};

struct StickerCreate {
    struct Item {
        macs::Mid mid;
        std::string stickerType;
    };
    std::vector<Item> value;
    struct Tag { constexpr static const char* value = "sticker-create";};
};

struct StickerRemove {
    struct Item {
        macs::Mid mid;
        std::string stickerType;
    };
    std::vector<Item> value;
    struct Tag { constexpr static const char* value = "sticker-remove";};
};

} // namespace hound::v2::changes::delta

BOOST_FUSION_ADAPT_STRUCT(hound::v2::changes::delta::Update::Item,
    mid, labels
)

BOOST_FUSION_ADAPT_STRUCT(hound::v2::changes::delta::Move::Item,
    mid, fid, tid, labels
)

BOOST_FUSION_ADAPT_STRUCT(hound::v2::changes::delta::ThreadsJoin::Item,
    mid, tid, labels
)

#define RO(name) YREFLECTION_AUTO_PROP_RO(name)
#define NO_SETTER yamail::data::reflection::readOnly(obj, val)

// Label view reflection
YREFLECTION_ADAPT_ADT(hound::v2::changes::delta::Label,
    RO(lid)
    RO(name)
    RO(color)
    RO(messagesCount)
    RO(creationTime)
    (type, obj->type().title(), NO_SETTER)
    (symbol, obj->symbolicName().title(), NO_SETTER)
    (revision, std::int64_t(obj->revision()), NO_SETTER)
)

BOOST_FUSION_ADAPT_STRUCT(hound::v2::changes::delta::MoveToTab::Item,
    mid, tab
)

BOOST_FUSION_ADAPT_STRUCT(hound::v2::changes::delta::StickerCreate::Item,
    mid, stickerType
)

BOOST_FUSION_ADAPT_STRUCT(hound::v2::changes::delta::StickerRemove::Item,
    mid, stickerType
)

#undef RO
#undef NO_SETTER
