#pragma once

#include <iomanip>

#include <macs/folder.h>
#include <yamail/data/reflection/details/adt.h>
#include <butil/datetime/date_utils.h>

namespace hound::server::handlers::v2::folders {
struct ApiTag;

template <typename T>
using AdtView = yamail::data::reflection::AdtView<T, ApiTag>;

using Folder = AdtView<macs::Folder>;

inline std::string formatDate(const std::string& unixtime) {
    const std::time_t t = DateUtils::string2timeFormat(unixtime, "%s");
    std::tm tm = *std::localtime(&t);
    std::stringstream ss;
    ss << std::put_time(&tm, "%FT%T%z");
    return ss.str();
}

} // namespace hound::server::handlers::v2::folders

#define RO(...) YREFLECTION_AUTO_PROP_RO(__VA_ARGS__)
#define NO_SETTER yamail::data::reflection::readOnly(obj, val)

YREFLECTION_ADAPT_ADT(hound::server::handlers::v2::folders::Folder,
    RO(id, fid)
    (name, obj->name(), NO_SETTER)
    RO(parentId)
    (type, obj->type().title(), NO_SETTER)
    (symbol, obj->symbolicName().title(), NO_SETTER)
    (createDate, hound::server::handlers::v2::folders::formatDate(obj->creationTime()), NO_SETTER)
    RO(isThreadable)
    RO(isSubscribedForSharedFolder, subscribedForSharedFolder)
    RO(unreadMessagesCount, newMessagesCount)
    RO(recentMessagesCount)
    RO(messagesCount)
    RO(bytes)
    (revision, std::int64_t(obj->revision()), NO_SETTER)
    RO(isUnvisited, unvisited)
)

#undef RO
#undef NO_SETTER

