#pragma once

#include <mail/hound/include/internal/v2/folders/folder_reflection.h>

#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <macs/folder_set.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::folders), Response,
    (std::vector<hound::server::handlers::v2::folders::Folder>, folders)
)

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::folders), Request,
    (macs::Uid, uid)
    (bool, withHidden)
)

namespace hound::server::handlers::v2::folders {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename MailboxGetter>
struct Method {
    MailboxGetter getMailbox;

    yamail::expected<Response> operator() (Request args) const {
        if (args.uid.empty()) {
            return yamail::make_unexpected(error_code{error::invalidArgument, "uid is empty"});
        }

        const macs::FolderSet folderSet = getMailbox(args.uid).folders(args.withHidden);
        std::vector<Folder> result;
        result.reserve(folderSet.size());
        for (const auto& f : folderSet) {
            result.emplace_back(f.second);
        }
        return Response{result};
    }
};

} // namespace hound::server::handlers::v2::folders

