#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers::v2::folders_tree {

struct Handler : public MacsHandler {
    explicit Handler(ConfigPtr config)
        : MacsHandler(std::move(config)) {
    }

protected:
    void execute(RequestPtr r, boost::asio::yield_context yield) const final {
        Request& request = *r;
        try {
            MailMetadataPtr metadata(getMetadata(request));
            executeMacs(r, metadata, yield);
        } catch (const macs::ParamsException&) {
            request.responseBadRequestException();
        } catch (...) {
            request.responseInternalErrorException();
        }
    }

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override;
};

} // namespace hound::server::handlers::v2::folders_tree
