#pragma once

#include <mail/hound/include/internal/v2/dereference.h>
#include <macs_pg/service/service.h>

namespace hound::server::handlers::v2::messages {

using namespace hound::v2;

template<typename Impl>
class Mailbox {
public:
    Mailbox(Impl impl, boost::asio::yield_context context)
        : impl(impl)
        , ctx(io_result::make_yield_context(context))
    { }

    decltype(auto) folders() const {
        return service().folders().getAllFolders(ctx);
    }

    decltype(auto) labels() const {
        return service().labels().getAllLabels(ctx);
    }

    decltype(auto) tabs() const {
        return service().tabs().canReadTabs(ctx) ? service().tabs().getAllTabs(ctx)
                                                 : macs::TabSet{};
    }

    template <class Range>
    decltype(auto) threadLabels(Range&& tids) const {
        return service().threads().getThreadLabels(std::forward<Range>(tids), ctx);
    }

    decltype(auto) labelThreadsCount(const macs::Lid& lid) const {
        return service().labels().getThreadsCount(lid, ctx);
    }

    decltype(auto) query() const {
        return service().envelopes().query();
    }

    template <class Result, class Query>
    Result fetch(Query&& query) const {
        auto result = query.get(ctx);
        return Result{std::begin(result), std::end(result)};
    }

private:
    decltype(auto) service() const {
        return detail::deref(impl);
    }

    using YieldCtx = decltype(io_result::make_yield_context(std::declval<boost::asio::yield_context>()));

    Impl impl;
    YieldCtx ctx;
};

}
