#pragma once

#include <macs/envelope.h>
#include <macs/thread_labels.h>
#include <yamail/data/reflection/details/adt.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/envelopes.h>

namespace hound::server::handlers::v2::messages {
struct FullTag;

template <typename T>
using FullView = yamail::data::reflection::AdtView<T, FullTag>;

using Envelope = FullView<macs::Envelope>;


struct ShortTag;

template <typename T>
using ShortView = yamail::data::reflection::AdtView<T, ShortTag>;

using ShortMessage = ShortView<macs::Envelope>;

} // hound::server::handlers::v2::messages

#define RO(...) YREFLECTION_AUTO_PROP_RO(__VA_ARGS__)
#define NO_SETTER yamail::data::reflection::readOnly(obj, val)

// Envelope view reflection
YREFLECTION_ADAPT_ADT(hound::server::handlers::v2::messages::Envelope,
    RO(mid)
    RO(fid)
    (tab, obj->tab() ? obj->tab().value().toString() : "", NO_SETTER)
    RO(threadId)
    RO(date)
    RO(receiveDate)
    (from, hound::helpers::toEmails(obj->from()), NO_SETTER)
    (replyTo, hound::helpers::toEmails(obj->replyTo()), NO_SETTER)
    (cc, hound::helpers::toEmails(obj->cc()), NO_SETTER)
    (bcc, hound::helpers::toEmails(obj->bcc()), NO_SETTER)
    (to, hound::helpers::toEmails(obj->to()), NO_SETTER)
    RO(subject)
    (subjectInfo, SubjectInfo(obj->subject()), NO_SETTER)
    RO(uidl)
    RO(imapId)
    RO(stid)
    RO(firstline)
    RO(inReplyTo)
    RO(references)
    RO(rfcId)
    RO(size)
    RO(threadCount)
    RO(newCount)
    RO(attachmentsCount)
    RO(attachmentsFullSize)
    RO(attachments)
    RO(labels)
    RO(types)
    (revision, std::int64_t(obj->revision()), NO_SETTER)
)

// Envelope view reflection
YREFLECTION_ADAPT_ADT(hound::server::handlers::v2::messages::ShortMessage,
    RO(mid)
    RO(receiveDate)
    (from, hound::helpers::toEmails(obj->from()), NO_SETTER)
    RO(subject)
    (subjectInfo, SubjectInfo(obj->subject()), NO_SETTER)
)

#undef RO
#undef NO_SETTER

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::messages), EnvelopesAndThreadLabels,
        (std::vector<hound::server::handlers::v2::messages::Envelope>, envelopes)
        (macs::ThreadLabelsList, threadLabels)
)
