#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>
#include <mail/hound/include/internal/v2/messages/mailbox.h>
#include <yamail/expected.h>

namespace hound::server::handlers::v2::messages {

template <class Method>
struct Handler : public MacsHandler {
    explicit Handler(ConfigPtr config)
        : MacsHandler(std::move(config)) {
    }

protected:
    using Params = server::QueryParams;

    void execute(RequestPtr r, boost::asio::yield_context yield) const final {
        Request& request = *r;
        try {
            MailMetadataPtr metadata(getMetadata(request));
            executeMacs(r, metadata, yield);
        } catch (const macs::ParamsException&) {
            request.responseBadRequestException();
        } catch (...) {
            request.responseInternalErrorException();
        }
    }

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yield) const override {
        const auto isBadRequestError = [](auto &ec) -> bool {
            return sharpei::client::Errors::UidNotFound == ec
                   || sharpei::client::Errors::HttpCode == ec
                   || macs::error::noSuchFolder == ec
                   || macs::error::noSuchLabel == ec
                   || macs::error::noSuchTab == ec;
        };

        try {
            typename Method::QueryParams params;
            Mailbox mailbox{metadata.get(), yield};
            Params queryParams;
            if (auto ec = queryParams.getParams(params, *request, mailbox)) {
                request->responseBadRequest(ec);
                return;
            }

            const auto out = Method{std::move(mailbox)}(std::move(params));

            if (!out) {
                request->responseBadRequest(out.error());
                return;
            }
            request->response(out.value());
        } catch (const boost::system::system_error &e) {
            if (isBadRequestError(e.code())) {
                request->responseBadRequestException();
            } else {
                request->responseInternalErrorException();
            }
        } catch (...) {
            request->responseInternalErrorException();
        }
    }
};

} // namespace hound::server::handlers::v2::messages
