#pragma once

#include <mail/hound/include/internal/v2/messages/reflection.h>
#include <mail/hound/include/internal/server/query_params.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <macs/queries/envelopes_query_in_tab.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <mail/hound/include/internal/wmi/pins.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::messages_in_tab_with_pins), Resp,
    (std::vector<hound::server::handlers::v2::messages::Envelope>, envelopes)
)

namespace hound::server::handlers::v2::messages_in_tab_with_pins {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename Mailbox>
struct Method {
    using Response = Resp;

    Mailbox mailbox;

    struct QueryParams :
            public hound::server::QueryParams::Page,
            public hound::server::QueryParams::Tab {
    };

    yamail::expected<Response> operator() (QueryParams params) const {
        const macs::Label pinnedLabel = mailbox.labels().at(macs::Label::Symbol::pinned_label);

        hound::pins::Factory<Mailbox> pinFactory(
                    mailbox, pinnedLabel, params.first, params.count);
        auto pinTabFactory = pinFactory.tab(params.tab);

        auto envelopes = mailbox.template fetch<std::vector<messages::Envelope>>(std::move(pinTabFactory));
        return Response{std::move(envelopes)};
    }
};

} // namespace hound::server::handlers::v2::messages_in_tab_with_pins

