#pragma once

#include <mail/hound/include/internal/v2/messages/reflection.h>
#include <mail/hound/include/internal/server/query_params.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <macs/queries/envelopes_query_in_tab.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::messages_unread_by_tab), Resp,
    (std::vector<hound::server::handlers::v2::messages::Envelope>, envelopes)
)

namespace hound::server::handlers::v2::messages_unread_by_tab {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename Mailbox>
struct Method {
    using Response = Resp;

    Mailbox mailbox;

    struct QueryParams :
            public hound::server::QueryParams::Page,
            public hound::server::QueryParams::Tab {
    };

    yamail::expected<Response> operator() (QueryParams params) const {
        auto query = mailbox.query().inTab(params.tab.type())
                .from(params.first)
                .count(params.count)
                .withoutLabel(mailbox.labels().at(macs::Label::Symbol::seen_label));

        auto envelopes = mailbox.template fetch<std::vector<messages::Envelope>>(std::move(query));
        return Response{std::move(envelopes)};
    }
};

} // namespace hound::server::handlers::v2::messages_unread_by_tab

