#pragma once

#include <mail/hound/include/internal/v2/dereference.h>
#include <macs_pg/service/service.h>
#include <macs_pg/service/factory.h>

namespace hound::server::handlers::v2::mids_by_tidsandlids {

using namespace hound::v2;

template<typename Impl, typename Context> class Mailbox {
public:
    Mailbox(Impl impl, Context context = Context{}) : impl(impl), context(context) {
    }

    macs::Mids midsByTidsAndLids(macs::Tids tids, macs::Lids lids) const {
        return service().envelopes().query()
            .midsByTidsAndLids()
            .withTids(std::move(tids))
            .withLids(std::move(lids))
            .get(context);
    }

private:
    decltype(auto) service() const {
        return detail::deref(impl);
    }

    Impl impl;
    Context context;
};

namespace sync {

struct MailboxGetter {
    macs::pg::ServiceFactoryPtr factory;
    Mailbox<macs::ServicePtr, io_result::sync_context> operator()(const macs::Uid& uid) const {
        return {factory->mailbox(uid)};
    }
};

}

namespace async {

using yield_context = decltype(macs::io::make_yield_context(std::declval<boost::asio::yield_context>()));

struct MailboxGetter {
    macs::pg::ServiceFactoryPtr factory;
    yield_context yield;
    Mailbox<macs::ServicePtr, yield_context> operator()(const macs::Uid& uid) const {
        return {factory->mailbox(uid), yield};
    }
};

}

}
