#pragma once

#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers::v2::mids_by_tidsandlids {

struct Handler : public MacsHandler {
    explicit Handler(ConfigPtr configuration) : MacsHandler(std::move(configuration)) {
    }

protected:
    virtual void execute(RequestPtr requestParam, boost::asio::yield_context yield) const final {
        auto& request = *requestParam;
        try {
            executeMacs(requestParam, getMetadata(request), yield);
        } catch (const macs::ParamsException&) {
            request.responseBadRequestException();
        } catch (...) {
            request.responseInternalErrorException();
        }
    }

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override;
};

}
