#pragma once

#include <mail/hound/include/internal/v2/dereference.h>
#include <macs_pg/service/service.h>
#include <macs_pg/service/factory.h>

namespace hound::server::handlers::v2::reset_tab_unvisited {

using namespace hound::v2;

template <typename Impl, typename Context>
class Mailbox {
    Impl impl;
    Context ctx;
public:
    Mailbox(Impl impl, Context ctx = Context{}) : impl(impl), ctx(ctx) {}

    decltype(auto) tabs() const {
        return service().tabs().getAllTabs(ctx);
    }

    void resetFresh(macs::Tab tab) const {
        service().tabs().resetFresh(tab, ctx);
    }

private:
    decltype(auto) service() const { return detail::deref(impl); }
};

namespace sync {

struct MailboxGetter {
    macs::pg::ServiceFactoryPtr factory;
    Mailbox<macs::ServicePtr, io_result::sync_context> operator()(const macs::Uid& uid) const {
        return {factory->mailbox(uid), {}};
    }
};

} // namespace sync

namespace async {

using yield_context = decltype(macs::io::make_yield_context(std::declval<boost::asio::yield_context>()));

struct MailboxGetter {
    macs::pg::ServiceFactoryPtr factory;
    yield_context yield;
    Mailbox<macs::ServicePtr, yield_context> operator()(const macs::Uid& uid) const {
        return {factory->mailbox(uid), yield};
    }
};

} // namespace async

} // namespace hound::server::handlers::v2::reset_tab_unvisited
