#pragma once

#include <mail/hound/include/internal/server/query_params.h>
#include <mail/hound/include/internal/server/handlers/macs.h>

namespace hound::server::handlers::v2::reset_tab_unvisited {

struct Handler : public MacsHandler {
    explicit Handler(ConfigPtr config)
        : MacsHandler(std::move(config)) {
    }

protected:
    struct Params : public QueryParams::Tab {};

    void execute(RequestPtr r, boost::asio::yield_context yield) const final {
        Request& request = *r;
        try {
            MailMetadataPtr metadata(getMetadata(request));
            executeMacs(r, metadata, yield);
        } catch (const macs::ParamsException&) {
            request.responseBadRequestException();
        } catch (...) {
            request.responseInternalErrorException();
        }
    }

    void executeMacs(RequestPtr request, MailMetadataPtr metadata, boost::asio::yield_context yieldCtx) const override;
};

} // namespace hound::server::handlers::v2::reset_tab_unvisited
