#pragma once

#include <mail/hound/include/internal/v2/messages/reflection.h>
#include <mail/hound/include/internal/server/query_params.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <macs/queries/envelopes_query_in_tab.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::short_fresh_message), Resp,
    (std::vector<hound::server::handlers::v2::messages::ShortMessage>, messages)
)

namespace hound::server::handlers::v2::short_fresh_message {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename Mailbox>
struct Method {
    using Response = Resp;

    Mailbox mailbox;

    struct QueryParams {};

    yamail::expected<Response> operator() (QueryParams /*params*/) const {
        const auto tabs = mailbox.tabs();
        const auto found = tabs.find(macs::Tab::Type::relevant);

        if (found == tabs.end()) {
            return Response{};
        }

        const auto& relevant = found->second;
        if (relevant.newMessagesCount() == 0 || relevant.freshMessagesCount() == 0) {
            return Response{};
        }

        auto query = mailbox.query().inTab(relevant.type())
                .withoutLabel(mailbox.labels().at(macs::Label::Symbol::seen_label))
                .from(0).count(1);
        auto messages = mailbox.template fetch<std::vector<messages::ShortMessage>>(std::move(query));
        return Response{std::move(messages)};
    }
};

} // namespace hound::server::handlers::v2::short_fresh_message

