#pragma once

#include <mail/hound/include/internal/v2/tabs/tab_reflection.h>

#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <boost/range/adaptors.hpp>
#include <macs/tab_set.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::tabs), Response,
    (std::vector<hound::server::handlers::v2::tabs::Tab>, tabs)
)

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::tabs), Request,
    (macs::Uid, uid)
)

namespace hound::server::handlers::v2::tabs {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename MailboxGetter>
struct Method {
    MailboxGetter getMailbox;

    yamail::expected<Response> operator() (Request args) const {
        if (args.uid.empty()) {
            return yamail::make_unexpected(error_code{error::invalidArgument, "uid is empty"});
        }

        auto mailbox = getMailbox(args.uid);

        if (!mailbox.canReadTabs()) {
            return Response{};
        }

        const auto& tabs = mailbox.tabs();
        const auto result = tabs | boost::adaptors::map_values;
        return Response{{std::begin(result), std::end(result)}};
    }
};

} // namespace hound::server::handlers::v2::tabs

