#pragma once

#include <macs/tab.h>
#include <yamail/data/reflection/details/adt.h>
#include <butil/datetime/date_utils.h>

namespace hound::server::handlers::v2::tabs {
struct ApiTag;

template <typename T>
using AdtView = yamail::data::reflection::AdtView<T, ApiTag>;

using Tab = AdtView<macs::Tab>;

inline std::string formatDate(const std::time_t& unixtime) {
    std::tm tm = *std::localtime(&unixtime);
    std::stringstream ss;
    ss << std::put_time(&tm, "%FT%T%z");
    return ss.str();
}

} // namespace hound::server::handlers::v2::tabs

#define RO(...) YREFLECTION_AUTO_PROP_RO(__VA_ARGS__)
#define NO_SETTER yamail::data::reflection::readOnly(obj, val)

YREFLECTION_ADAPT_ADT(hound::server::handlers::v2::tabs::Tab,
    (type, obj->type().toString(), NO_SETTER)
    (createDate, hound::server::handlers::v2::tabs::formatDate(obj->creationTime()), NO_SETTER)
    RO(messagesCount)
    RO(unreadMessagesCount, newMessagesCount)
    RO(bytes)
    (revision, std::int64_t(obj->revision()), NO_SETTER)
    RO(freshMessagesCount)
    (isUnvisited, bool, bool, (obj->freshMessagesCount() > 0), NO_SETTER)
)

#undef RO
#undef NO_SETTER
