#pragma once

#include <mail/hound/include/internal/v2/messages/reflection.h>
#include <mail/hound/include/internal/server/query_params.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <macs/queries/envelopes_query_in_tab.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::threads_by_tab), Resp,
    (hound::server::handlers::v2::messages::EnvelopesAndThreadLabels, threads_by_folder)
)

namespace hound::server::handlers::v2::threads_by_tab {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename Mailbox>
struct Method {
    using Response = Resp;

    Mailbox mailbox;

    struct QueryParams :
            public hound::server::QueryParams::Page,
            public hound::server::QueryParams::Tab,
            public hound::server::QueryParams::TimestampRange {
    };

    yamail::expected<Response> operator() (QueryParams params) const {
        auto query = mailbox.query().inTab(params.tab.type())
                .from(params.first)
                .count(params.count)
                .groupByThreads();

        if (params.timestampRange) {
            query.withinInterval(*params.timestampRange);
        }

        auto envelopes = mailbox.template fetch<std::vector<messages::Envelope>>(std::move(query));
        messages::EnvelopesAndThreadLabels result { std::move(envelopes), {}};

        std::vector<std::string> tids;
        std::transform(result.envelopes.begin(), result.envelopes.end(),
                       std::back_inserter(tids), [](auto& e) { return e->threadId(); });
        result.threadLabels = mailbox.threadLabels(std::move(tids));

        return Response{std::move(result)};
    }
};

} // namespace hound::server::handlers::v2::threads_by_tab

