#pragma once

#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <mail/hound/include/internal/wmi/errors.h>
#include <macs/types.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::with_attaches_counters), Response,
    (uint64_t,  messagesCount)
    (uint64_t,  newMessagesCount)
)

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::with_attaches_counters), Request,
    (macs::Uid, uid)
)

namespace hound::server::handlers::v2::with_attaches_counters {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename MailboxGetter>
struct Method {
    MailboxGetter getMailbox;

    yamail::expected<Response> operator() (Request args) const {
        if (args.uid.empty()) {
            return yamail::make_unexpected(error_code{error::invalidArgument, "uid is empty"});
        }

        const auto mailbox = getMailbox(args.uid);
        const auto attachesCounters = mailbox.getAttachesCounters();

        return Response{attachesCounters.count, attachesCounters.count - attachesCounters.seen};
    }
};

} // namespace hound::server::handlers::v2::with_attaches_counters


