#pragma once

#include <mail/hound/include/internal/wmi/yplatform/reflection/database_info.h>

#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <macs/folder_set.h>
#include <mail/hound/include/internal/wmi/errors.h>
#include <yamail/expected.h>

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::yamail_status), Response,
                           (hound::helpers::DatabaseInfo, database_info)
)

BOOST_FUSION_DEFINE_STRUCT((hound::server::handlers::v2::yamail_status), Request,
                           (macs::Uid, uid)
)

namespace hound::server::handlers::v2::yamail_status {

namespace error = libwmi::error;
using mail_errors::error_code;

template <typename MailboxGetter>
struct Method {
    MailboxGetter getMailbox;

    yamail::expected<Response> operator() (Request args) const {
        if (args.uid.empty()) {
            return yamail::make_unexpected(error_code{error::invalidArgument, "uid is empty"});
        }

        const auto state = getMailbox(args.uid).dbState();
        return Response{helpers::databaseInfo(state)};
    }
};

} // namespace hound::server::handlers::v2::yamail_status

