#pragma once

#include <string>
#include <vector>
#include <map>
#include <stdexcept>

#include <mail/hound/include/internal/wmi/errors.h>
#include <macs/errors.h>
#include <pgg/error.h>
#include <sharpei_client/errors.h>

inline libwmi::error::error_code errorCode2WmiError(const boost::system::error_code & ec) {
    if( ec.category() == ::libwmi::error::category() ) {
        return ec;
    } else if( ec == ::macs::error::duplicateLabelSymbol ) {
        return libwmi::error::dbUniqueConstraint;
    } else if( ec == ::macs::error::noSuchLabel ) {
        return libwmi::error::noSuchLabel;
    } else if( ec == ::macs::error::cantModifyLabel ) {
        return libwmi::error::invalidArgument;
    } else if( ec == ::macs::error::invalidArgument ) {
        return libwmi::error::invalidArgument;
    } else if( ec == ::macs::error::userNotInitialized ) {
        return libwmi::error::notInitialized;
    } else if( ec == ::macs::error::folderAlreadyExists ) {
        return libwmi::error::dbUniqueConstraint;
    } else if( ec == ::macs::error::noSuchFolder ) {
        return libwmi::error::noSuchFolder;
    } else if( ec == ::macs::error::folderCantBeParent ) {
        return libwmi::error::invalidArgument;
    } else if( ec == ::macs::error::cantModifyFolder ) {
        return libwmi::error::invalidArgument;
    } else if( ec == ::macs::error::folderIsNotEmpty ) {
        return libwmi::error::folderNotEmpty;
    } else if( ec == ::pgg::errc::databaseReadOnly ) {
        return libwmi::error::dbReadOnly;
    } else if( ec == ::macs::error::noSuchMessage ) {
        return libwmi::error::noSuchMessage;
    } else if ( ec == ::sharpei::client::Errors::HttpCode ) {
        return libwmi::error::invalidArgument;
    } else if ( ec == ::sharpei::client::Errors::UidNotFound ) {
        return libwmi::error::uidNotFound;
    } else if ( ec == ::sharpei::client::Errors::RegistrationInProgress ) {
        return libwmi::error::regInProgress;
    } else if ( ec == ::macs::error::noSuchTab ) {
        return libwmi::error::noSuchTab;
    }
    return libwmi::error::dbUnknownError;
}
