#pragma once

#include <macs_pg/logging.h>
#include <mail/hound/include/internal/logger.h>

namespace hound {

template <typename Logger>
using MacsPgLog = macs::pg::logging::v2::TypedLog<Logger>;

template<typename Logger>
macs::pg::logging::v2::LogPtr createMacsPgLogger(Logger l) {
    return std::make_shared<MacsPgLog<Logger>>(std::move(l));
}

} // namespace hound
