#pragma once

#include <macs/folder.h>
#include <macs/folder_set.h>

namespace hound::helpers {

void filterFoldersWithSymbols(const macs::FolderSet& folderSet,
        const std::list<macs::Folder::Symbol>& symbols, macs::FidList& fids);
void filterFoldersWithoutSymbols(const macs::FolderSet& folderSet,
        const std::list<macs::Folder::Symbol>& symbols, macs::FidList& fids);

void filterUsefulFolders(const macs::FolderSet& folderSet, macs::FidList& fids);
void filterUnreadFolders(const macs::FolderSet& folderSet, macs::FidList& fids);

macs::FidList getUnreadUsefulFolders(const macs::FolderSet& folderSet);

}
