#pragma once

#include <mail/hound/include/internal/logger.h>

#include <mail_getter/logging.h>

namespace hound {

class MulcagateLog : public mail_getter::logging::Log {
public:
    using ServiceName = mail_getter::logging::ServiceName;
    using Message = mail_getter::logging::Message;
    using Logger = hound::ContextLogger;

    MulcagateLog(Logger l) : logger(std::move(l)) {}

    void warning(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, warning, log::where_name=name, log::message=msg);
    }
    void error(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, error, log::where_name=name, log::message=msg);
    }
    void notice(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, notice, log::where_name=name, log::message=msg);
    }
    void debug(const ServiceName& name, const Message& msg) override {
        LOGDOG_(logger, debug, log::where_name=name, log::message=msg);
    }
    static mail_getter::logging::LogPtr create (Logger l) {
        return std::make_shared<MulcagateLog>(std::move(l));
    }

private:
    Logger logger;
};

} // namespace hound
