#pragma once

#include <mail/http_getter/client/include/module.h>
#include <yamail/data/reflection/details/adt.h>
#include <ymod_webserver/request.h>


namespace hound {

struct PassportResponse {
    std::string status;
    std::optional<std::vector<std::string>> errors;
    unsigned int httpCode = 0;

    bool hasError() const {
        return errors.has_value() && !errors->empty() || !http_getter::helpers::successCode(httpCode);
    }

    bool hasOnlyRetriableErrors() const {
        using namespace http_getter::helpers;
        if (!hasError()) {
            return false;
        } else if (retriableCode(httpCode)) {
            return true;
        } else if (!successCode(httpCode) || !errors.has_value()) {
            return false;
        }

        const std::vector<std::string> retriableErrors = {
                "backend.blackbox_failed",
                "backend.yasms_failed",
                "backend.database_failed",
                "backend.redis_failed"
        };
        return std::all_of(errors->begin(), errors->end(), [&] (const auto& error) {
            return std::count(retriableErrors.begin(), retriableErrors.end(), error);
        });
    }
};

PassportResponse passportUnfreeze(const http_getter::TypedClientPtr& client, const http_getter::TypedEndpoint& passportEndpoint,
                                    const std::string& uid, boost::asio::yield_context yield);

} // namespace hound

YREFLECTION_ADAPT_ADT(hound::PassportResponse,
    YREFLECTION_MEMBER(std::string, status)
    YREFLECTION_MEMBER(std::optional<std::vector<std::string>>, errors)
)
