#ifndef NUMCODES_H
#define NUMCODES_H

#include <algorithm>
#include <string>

//#define ASCII_SORT

// the size is less than radix!!!
extern const char * pSpecChar;
extern const unsigned int specSize;

// Here go several routines for conversion from int to a 62-mal system
const unsigned int H = 'z' - 'a' + 1;
const unsigned radix = 2 * H + 10;
/* General note on ascDig flag
** if ascDig is false then the larger digit is in sort order
** the less value it represents
*/

inline unsigned int getRadix62()
{
    return radix;
}

// converts to alpha-numeric representation
inline char encDig62(unsigned int n, bool ascDig)
{
   if (ascDig) {
#ifdef ASCII_SORT
       if (n < 10) {
           return '0' + n;
       }
       n -= 10;
       if (n < H) {
           return 'A' + n;
       }
       n -= H;
       return 'a' + n;
#else  // Oracle sort
        if (n < 2 * H) {
            return static_cast<char>(n/2 + ((n % 2) ? 'a': 'A'));
        } else {
            return static_cast<char>(n - 2 * H + '0');
        }
#endif
    } else {
        return encDig62(radix - n - 1, true);
    }

}
// converts digit back to its value, -1 if wrong char
inline int decDig62(unsigned char c, bool ascDig)
{
    if (ascDig) {
#ifdef ASCII_SORT
        if (isdigit(c))
            return c - '0';

        if (c >= 'A' && c <= 'Z')
            return 10 + c - 'A';

        if (c >= 'a' && c <= 'z')
            return 10 + H + c - 'a';
#else // Oracle sort
        if (isdigit(c))
            return c - '0' + 2 * H;

        if (c >= 'A' && c <= 'Z')
            return 2 * (c - 'A');

        if (c >= 'a' && c <= 'z')
            return 2 * (c - 'a') + 1;
#endif
        return -1;
    } else {
        int res = decDig62(c, true);
        if (res < 0) {
            return -1;
        }
        return static_cast<int>(radix) - res - 1;
    }

}
// determine the minimum size of the string in the 62-mal system
inline unsigned int maxDig62(unsigned int n)
{
    unsigned int res = 0;
    do {
        res++;
        n /= radix;
    } while (n);
    return res;
};

// encode number in 62-mal system
inline std::string encNum62(unsigned int n, int minDig, bool ascDig)
{
    if (!minDig) {
        minDig = 1;
    }
    std::string res;
    do {
        res.insert(res.begin(), 1, encDig62(n % radix, ascDig));
        n /= radix;
        minDig--;
    } while (n || minDig > 0);

    return res;
};

// returns negative in case of bad number
inline int decNum62(const std::string & s, unsigned int b, unsigned int e, bool ascDig)
{
    int n = 0;
    if (b >= s.length() || e >= s.length()) {
        return -2;
    }

    for (unsigned int i = b; i <= e; ++i) {
        int v = decDig62(static_cast<unsigned char>(s[i]), ascDig);
        if (v < 0)
            return -1;
        n = n * static_cast<int>(radix) + v;
    }

    return n;
}

// encSpecChar and decSpecChar are designed for compact encoding of common chars
inline std::string encSpecChar(unsigned char c)
{
    const char * p = std::find(pSpecChar, pSpecChar + specSize, c);
    unsigned int indx = static_cast<unsigned int>(p - pSpecChar);

    if (indx < specSize) { // if common char then it is one-byte
        return encNum62(indx, 1, true);
    } else {
        return encNum62(specSize * radix + c, 2, true); // otherwise it is 2-byte
    }
}
// returns negative in case of wrong char
inline int decSpecChar(const std::string & str, unsigned int start, unsigned int & sz)
{
    sz = 0;

    if (start >= str.length()) {
        return -1;
    }
    int v = decDig62(static_cast<unsigned char>(str[start]), true);
    if (v < 0) {
        return -2;
    }
    if (v < static_cast<int>(specSize)) {
        sz = 1;

        return pSpecChar[v];
    }

    if (start + 1 >= str.length()) {
        return -3;
    }
    int c = decNum62(str, start, start + 1, true) - static_cast<int>(specSize) * static_cast<int>(radix);
    if (c < 0 || c > 255) {
        return -4;
    }
    sz = 2;
    return c;
}
#endif
