#ifndef RMREFWD_H
#define RMREFWD_H

#include <string>

const char bracketOpChar = '\02';
const char prefixOpChar = '\03';
const char suffixOpChar = '\04';
extern const char * allOpsInString;
// Functions removes special affixes like Re[2], Fwd, etc.
// As a result resSuffix contains information to reconstruct original string
// from a stripped one
//
void stripReFwd(const std::string & srcStr, std::string & resStr, std::string & sortOps, std::string & encOps, bool rmblobs = true);

// Reverse function to stripReFwd
// Returns 0 on success, negative value if the format of resSuffix is wrong

int reconstrPartsReFwd(const std::string & strippedStr, std::string& prefix,
                       std::string & resStr, std::string& suffix,
                       const std::string& encOps);
#endif
