#pragma once

namespace hound {

template <typename ArgList, typename Logger>
inline void filterEmptyItems(ArgList& list, Logger& logger, const char * name, const char * func) {
    auto it = std::remove_if(list.begin(), list.end(), [] (const std::string& item) {
        return item.empty();
    });

    if (it != list.end()) {
        LOGDOG_(logger, notice, log::where_name=func,
                log::message=std::string("empty elements in ") + name + " list");
        list.erase(it, list.end());
    }
}

} // namespace hound

