#pragma once

#include <stdexcept>
#include <unordered_map>
#include <macs/envelopes_repository.h>

namespace filter_search {

typedef std::unordered_map<std::string, std::string> FolderSetMap;
typedef std::unordered_map<std::string, macs::EnvelopesSorting> OrderMap;

inline const OrderMap& getOrderMap() {
    using namespace macs;
    static const OrderMap orderMap = {
        {"date", {SortingType_descending}},
        {"date1", {SortingType_ascending}},
    };
    return orderMap;
}

inline macs::EnvelopesSorting getEnvelopesSorting(const std::string& orderParam) {
    const auto found = getOrderMap().find(orderParam);
    return (found == getOrderMap().end()) ? macs::EnvelopesSorting() : found->second;
}

inline const FolderSetMap& getFolderSetMap() {
    static const FolderSetMap folderSetMap = {
        {"",""},
        {"default", "search_folders_default"},
        {"private_subscribed", "search_folders_private"},
        {"private_opened_allowed", "search_folders_all"},
        {"opened_allowed", "search_folders_shared"}
    };
    return folderSetMap;
}

inline std::string getFolderSetQueryPart(const std::string& folderSetParam) {
    const auto found = getFolderSetMap().find(folderSetParam);
    return (found == getFolderSetMap().end()) ? "search_folders_default" : found->second;
}

inline bool toBoolean(const std::string& value, const std::string& name) {
    static const std::unordered_map<std::string, bool> values = {
        {"1", true},
        {"t", true},
        {"y", true},
        {"yes", true},
        {"true", true},
        {"0", false},
        {"f", false},
        {"n", false},
        {"no", false},
        {"false", false},
    };

    const auto result = values.find(value);

    if (result != values.end()) {
        return result->second;
    } else {
        std::ostringstream stream;
        stream << "'" << value << "' is invalid value for parameter " << name;
        throw std::invalid_argument(stream.str());
    }
}

} //namespace filter_search
