#pragma once

#include <macs/database_info_types.h>

namespace hound::helpers {

struct DatabaseInfo {
    std::string name;
    std::string state;
};

inline std::string toString(macs::DatabaseState::State value) {
    switch (value) {
        case macs::DatabaseState::State::readWrite:
            return "read_write";
        case macs::DatabaseState::State::readOnly:
            return "read_only";
        case macs::DatabaseState::State::singleReplica:
            return "single_replica";
        case macs::DatabaseState::State::singleReplicaOnly:
            return "single_replica_only";
        case macs::DatabaseState::State::masterOnly:
            return "master_only";
        case macs::DatabaseState::State::dbDead:
            return "db_dead";
        default:
            throw std::logic_error("Can't convert macs::DatabaseState value to string");
    }
}

inline DatabaseInfo databaseInfo(const macs::DatabaseState& value) {
    return DatabaseInfo {value.name, toString(value.state)};
}

}
