#pragma once

#include <unordered_map>
#include <boost/optional.hpp>
#include <macs/folder_set.h>
#include <macs/label_set.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/envelopes.h>

namespace hound::helpers {

using LabelsMap = std::map<std::string, macs::Label>;

struct FolderWithPath {
    macs::Folder folder;
    macs::Folder::Path path;
};

class DetailedEnvelope : public Envelope {
public:
    DetailedEnvelope(Envelope envelope,
                     const FolderWithPath& folder,
                     LabelsMap labels)
        : Envelope(std::move(envelope)),
          folder_(folder),
          labels_(std::move(labels))
    {}

    DetailedEnvelope(Envelope envelope,
                     LabelsMap labels)
        : Envelope(std::move(envelope)),
          labels_(std::move(labels))
    {}

    const boost::optional<FolderWithPath>& folder() const {
        return folder_;
    }

    const LabelsMap& labelsInfo() const {
        return labels_;
    }

    const LabelsMap& specialLabelsInfo() const {
        return specialLabels_;
    }

private:
    const boost::optional<FolderWithPath> folder_;
    const LabelsMap labels_;
    const LabelsMap specialLabels_;
};

namespace detailed_envelopes {

using Mid = std::string;
using Lid = std::string;
using Fid = std::string;
using LidsMids = std::unordered_map<Lid, std::vector<Mid>>;
using FidsMids = std::unordered_map<Fid, std::vector<Mid>>;

struct Result {
    std::vector<DetailedEnvelope> values;
    LidsMids missingLids;
    FidsMids missingFids;
};

} // namespace detailed_envelopes

detailed_envelopes::Result detailedEnvelopes(std::vector<Envelope> envelopes,
                                             const macs::FolderSet& folders,
                                             const macs::LabelSet& labels);

} // namespace hound
