#pragma once

#include <string>
#include <vector>
#include <butil/email/email.h>
#include <butil/network/rfc2822.h>
#include <mail_getter/recognizerWrapper.h>

namespace hound::helpers {

const Recognizer::Wrapper& recognizer(const std::string& languageDict = "", const std::string& languageWeights = "",
                                      const std::string& encodingDict = "");

struct Email {
    Email(const std::string& local, const std::string& domain, const std::string displayName)
            : local(local), domain(domain), displayName(displayName) {
    }
    Email() { }

    std::string local;
    std::string domain;
    std::string displayName;
};

typedef std::vector<Email> Emails;

helpers::Emails toEmails(const std::string& emails);
helpers::Email convertEmail(const ::Email& email);

namespace details {

template<typename NormalizeFn>
void setDisplayName(helpers::Email& email, const std::string& dn, NormalizeFn normalize) {
    if (!dn.empty()) {
        try {
            email.displayName = normalize(dn);
        } catch (const std::exception& e) {
        }
    }
    if (email.displayName.empty()) {
        email.displayName = rfc2822ns::join_address(email.local, email.domain);
    }
}

} // namespace details

} //namespace hound
