#pragma once

#include <boost/range/algorithm/copy.hpp>
#include <macs/envelope.h>
#include <macs/thread_labels.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/email.h>
#include <mail/hound/include/internal/wmi/service/subject/subject.h>
#include <mail/hound/include/internal/config.h>
#include <macs/tabs_map.h>

namespace hound::helpers {

class Envelope {
public:
    Envelope(macs::Envelope envelope) : envelope_(std::move(envelope)) {}

#define PROXY_GET(Type, method) \
    Type method() const { \
        return envelope_.method(); \
    }

#define UNUSED_LEGACY_GET(Type, method) \
    const Type& method() const { \
        static Type dummy;\
        return dummy; \
    }

#define CONVERT_GET(Type, method, convert) \
    Type method() const { \
        return convert(envelope_.method()); \
    }

    PROXY_GET(const std::string&, mid)
    PROXY_GET(const std::string&, fid)
    PROXY_GET(const std::string&, threadId)
    PROXY_GET(macs::Revision, revision)
    PROXY_GET(std::time_t, date)
    PROXY_GET(std::time_t, receiveDate)
    CONVERT_GET(Emails, from, toEmails)
    CONVERT_GET(Emails, replyTo, toEmails)
    PROXY_GET(const std::string&, subject)

    SubjectInfo subjectInfo() const {
        return envelope_.subject();
    }

    CONVERT_GET(Emails, cc, toEmails)
    CONVERT_GET(Emails, bcc, toEmails)
    UNUSED_LEGACY_GET(std::string, hdrStatus)
    CONVERT_GET(Emails, to, toEmails)
    UNUSED_LEGACY_GET(std::string, hdrLastStatus)
    PROXY_GET(const std::string&, uidl)
    PROXY_GET(const std::string&, imapId)
    UNUSED_LEGACY_GET(std::string, ImapModSeq)
    PROXY_GET(const std::string&, stid)
    PROXY_GET(const std::string&, firstline)
    PROXY_GET(const std::string&, inReplyTo)
    PROXY_GET(const std::string&, references)
    PROXY_GET(const std::string&, rfcId)
    PROXY_GET(std::size_t, size)
    PROXY_GET(int32_t, threadCount)
    PROXY_GET(const std::string&, extraData)
    PROXY_GET(std::size_t, newCount)
    PROXY_GET(std::size_t, attachmentsCount)
    PROXY_GET(std::size_t, attachmentsFullSize)
    PROXY_GET(const macs::Attachments&, attachments)
    PROXY_GET(const std::vector<std::string>&, labels)
    UNUSED_LEGACY_GET(std::vector<std::string>, specialLabels)
    PROXY_GET(const std::set<int>&, types)

    std::string tab() const {
        return envelope_.tab() ? envelope_.tab().value().toString() : "";
    }

#undef CONVERT_GET
#undef PROXY_GET
#undef UNUSED_LEGACY_GET

protected:
    const macs::Envelope& envelope() const {
        return envelope_;
    }

private:
    macs::Envelope envelope_;
};

struct EnvelopesAndThreadLabels {
    std::vector<Envelope> envelopes;
    macs::ThreadLabelsList threadLabels;
};

}
