#pragma once

#include <mail/hound/include/internal/wmi/yplatform/helpers/detailed_envelopes.h>

namespace hound::helpers {

struct EnvelopesWithMailboxRevision {
    std::vector<helpers::Envelope> envelopes;
    macs::Revision::Value mailboxRevision;
};

struct DetailedEnvelopesWithMailboxRevision {
    std::vector<helpers::DetailedEnvelope> detailedEnvelopes;
    macs::Revision::Value mailboxRevision;
};

inline DetailedEnvelopesWithMailboxRevision envelopesWithRevision(
        std::vector<helpers::DetailedEnvelope> e, macs::Revision r) {
    return DetailedEnvelopesWithMailboxRevision{std::move(e), r.value()};
}

inline EnvelopesWithMailboxRevision envelopesWithRevision(
        std::vector<helpers::Envelope> e, macs::Revision r) {
    return EnvelopesWithMailboxRevision{std::move(e), r.value()};
}

}
