#pragma once

#include <yamail/data/reflection/details/adt.h>

struct MidHids {
    std::string mid;
    std::vector <std::string> hids;
};

struct UidDownloads {
    std::string uid;
    std::vector <MidHids> downloads;
};

struct UidSids {
    std::string uid;
    std::vector<std::string> sids;
};

using AttachSidsRequest = std::vector<UidDownloads>;
using AttachSidsResponse = std::vector<UidSids>;

BOOST_FUSION_ADAPT_STRUCT(MidHids,
(std::string, mid)
(std::vector <std::string>, hids))

BOOST_FUSION_ADAPT_STRUCT(UidDownloads,
(std::string, uid)
(std::vector<MidHids>, downloads))

BOOST_FUSION_ADAPT_STRUCT(UidSids,
(std::string, uid)
(std::vector<std::string>, sids))
