#pragma once

#include <yamail/data/reflection/details/adt.h>
#include <mail/hound/include/internal/wmi/yplatform/helpers/envelopes.h>
#include <mail/hound/include/internal/wmi/yplatform/reflection/email.h>

YREFLECTION_ADAPT_ADT(macs::ThreadLabels::TLabel,
        YREFLECTION_ROPROPERTY(std::string, lid)
        YREFLECTION_ROPROPERTY(unsigned int, cnt)
)

YREFLECTION_ADAPT_ADT(macs::ThreadLabels,
        YREFLECTION_ROPROPERTY(std::string, tid)
        YREFLECTION_ROPROPERTY(unsigned long long, tscn)
        YREFLECTION_ROPROPERTY(std::vector<macs::ThreadLabels::TLabel>, labels)
)

BOOST_FUSION_ADAPT_STRUCT(hound::helpers::EnvelopesAndThreadLabels,
        (std::vector<hound::helpers::Envelope>, envelopes)
        (macs::ThreadLabelsList, threadLabels) )

BOOST_FUSION_ADAPT_STRUCT(macs::AttachmentDescriptor,
        (std::string, m_hid)
        (std::string, m_contentType)
        (std::string, m_fileName)
        (size_t, m_size) )

YREFLECTION_ADAPT_ADT(SubjectInfo,
        YREFLECTION_ROPROPERTY(std::string, type)
        YREFLECTION_ROPROPERTY(std::string, prefix)
        YREFLECTION_ROPROPERTY(std::string, subject)
        YREFLECTION_ROPROPERTY(std::string, postfix)
        YREFLECTION_ROPROPERTY(bool, isSplitted)
)

YREFLECTION_ADAPT_ADT(hound::helpers::Envelope,
        YREFLECTION_ROPROPERTY(std::string, mid)
        YREFLECTION_ROPROPERTY(std::string, fid)
        YREFLECTION_ROPROPERTY(std::string, threadId)
        YREFLECTION_ROPROPERTY(unsigned long, revision)
        YREFLECTION_ROPROPERTY(std::time_t, date)
        YREFLECTION_ROPROPERTY(std::time_t, receiveDate)
        YREFLECTION_ROPROPERTY(hound::helpers::Emails, from)
        YREFLECTION_ROPROPERTY(hound::helpers::Emails, replyTo)
        YREFLECTION_ROPROPERTY(std::string, subject)
        YREFLECTION_ROPROPERTY(SubjectInfo, subjectInfo)
        YREFLECTION_ROPROPERTY(hound::helpers::Emails, cc)
        YREFLECTION_ROPROPERTY(hound::helpers::Emails, bcc)
        YREFLECTION_ROPROPERTY(std::string, hdrStatus)
        YREFLECTION_ROPROPERTY(hound::helpers::Emails, to)
        YREFLECTION_ROPROPERTY(std::string, hdrLastStatus)
        YREFLECTION_ROPROPERTY(std::string, uidl)
        YREFLECTION_ROPROPERTY(std::string, imapId)
        YREFLECTION_ROPROPERTY(std::string, ImapModSeq)
        YREFLECTION_ROPROPERTY(std::string, stid)
        YREFLECTION_ROPROPERTY(std::string, firstline)
        YREFLECTION_ROPROPERTY(std::string, inReplyTo)
        YREFLECTION_ROPROPERTY(std::string, references)
        YREFLECTION_ROPROPERTY(std::string, rfcId)
        YREFLECTION_ROPROPERTY(std::size_t, size)
        YREFLECTION_ROPROPERTY(int32_t, threadCount)
        YREFLECTION_ROPROPERTY(std::string, extraData)
        YREFLECTION_ROPROPERTY(std::size_t, newCount)
        YREFLECTION_ROPROPERTY(std::size_t, attachmentsCount)
        YREFLECTION_ROPROPERTY(std::size_t, attachmentsFullSize)
        YREFLECTION_ROPROPERTY(macs::Attachments, attachments)
        YREFLECTION_ROPROPERTY(std::vector<std::string>, labels)
        YREFLECTION_ROPROPERTY(std::vector<std::string>, specialLabels)
        YREFLECTION_ROPROPERTY(std::set<int>, types)
        YREFLECTION_ROPROPERTY(std::string, tab)
)
