#pragma once

#include <mail/hound/include/internal/wmi/common/error_codes.h>
#include <boost/fusion/adapted/struct.hpp>

namespace hound {

struct ErrorStruct
{
    ErrorStruct() = default;

    ErrorStruct(const ::libwmi::error::error_code& e, const std::string& reason)
            : code(e.value()), reason(reason) {
        message = e.message();
    }

    int code = 0;
    std::string message;
    std::string reason;
};

} //namespace hound

BOOST_FUSION_ADAPT_STRUCT(hound::ErrorStruct,
        (int, code)
        (std::string, message)
        (std::string, reason) )
