#pragma once

#include <mail/hound/include/internal/wmi/yplatform/helpers/detailed_envelopes.h>
#include <yamail/data/reflection/details/adt.h>
#include <macs/folders_repository.h>

struct FolderOptions {
    size_t getPosition;
};

namespace yamail::data::reflection {

template <>
struct is_map<macs::FolderSet> : std::true_type {};

} // namespace yamail::data::reflection

BOOST_FUSION_ADAPT_STRUCT(FolderOptions,
        (size_t, getPosition) )

YREFLECTION_ADAPT_ADT(macs::Folder::Type,
        YREFLECTION_ROPROPERTY(int, code)
        YREFLECTION_ROPROPERTY(std::string, title)
)

YREFLECTION_ADAPT_ADT(macs::Folder::Symbol,
        YREFLECTION_ROPROPERTY(int, code)
        YREFLECTION_ROPROPERTY(std::string, title)
)

YREFLECTION_ADAPT_ADT(hound::helpers::FolderWithPath,
        (name, std::string, std::string, obj.path.toString(), (void(obj), void(val)))
        (isUser, bool, bool, !obj.folder.isSystem(), (void(obj), void(val)))
        (isSystem, bool, bool, obj.folder.isSystem(), (void(obj), void(val)))
        (type, macs::Folder::Type, macs::Folder::Type, obj.folder.type(), (void(obj), void(val)))
        (symbolicName, macs::Folder::Symbol, macs::Folder::Symbol, obj.folder.symbolicName(), (void(obj), void(val)))
        (bytes, std::size_t, std::size_t, obj.folder.bytes(), (void(obj), void(val)))
        (messagesCount, std::size_t, std::size_t, obj.folder.messagesCount(), (void(obj), void(val)))
        (newMessagesCount, std::size_t, std::size_t, obj.folder.newMessagesCount(), (void(obj), void(val)))
        (recentMessagesCount, std::size_t, std::size_t, obj.folder.recentMessagesCount(), (void(obj), void(val)))
        (unvisited, bool, bool, obj.folder.unvisited(), (void(obj), void(val)))
        (folderOptions, FolderOptions, FolderOptions, FolderOptions{obj.folder.position()}, (void(obj), void(val)))
        (position, std::size_t, std::size_t, obj.folder.position(), (void(obj), void(val)))
        (parentId, std::string, std::string, obj.folder.parentId(), (void(obj), void(val)))
        (pop3On, std::string, std::string, obj.folder.pop3On() ? "1" : "0", (void(obj), void(val)))
        (scn, std::string, std::string, std::to_string(obj.folder.revision()), (void(obj), void(val)))
        (creationTime, std::string, std::string, obj.folder.creationTime(), (void(obj), void(val)))
        (subscribed, std::string, std::string, (void(obj.folder), ""), (void(obj), void(val)))
        (shared, std::string, std::string, obj.folder.subscribedForSharedFolder() ? "1" : "0", (void(obj), void(val)))
        (subscribedForSharedFolder, bool, bool, obj.folder.subscribedForSharedFolder(), (void(obj), void(val)))
        (revision, unsigned long, unsigned long, obj.folder.revision(), (void(obj), void(val)))
        (isThreadable, bool, bool, obj.folder.isThreadable(), (void(obj), void(val)))
)
