#pragma once

#include <yamail/data/reflection/details/adt.h>
#include <macs/folder.h>

namespace hound {

struct FoldersCounters {
    explicit FoldersCounters(const macs::Folder& f) :
        messagesCount(f.messagesCount())
        , newMessagesCount(f.newMessagesCount())
    {}

    size_t messagesCount;
    size_t newMessagesCount;
};

} //namespace hound

YREFLECTION_ADAPT_ADT(hound::FoldersCounters,
        (cnt, size_t, size_t, obj.messagesCount, (void(obj), void(val)))
        (new, size_t, size_t, obj.newMessagesCount, (void(obj), void(val)))
)
