#pragma once

#include <yamail/data/reflection/details/adt.h>
#include <macs/label.h>

namespace yamail::data::reflection {

template <>
struct is_map<macs::LabelSet> : std::true_type {};

} // namespace yamail::data::reflection

YREFLECTION_ADAPT_ADT(macs::Label::Type,
        YREFLECTION_ROPROPERTY(int, code)
        YREFLECTION_ROPROPERTY(std::string, title)
)

YREFLECTION_ADAPT_ADT(macs::Label::Symbol,
        YREFLECTION_ROPROPERTY(int, code)
        YREFLECTION_ROPROPERTY(std::string, title)
)

YREFLECTION_ADAPT_ADT(macs::Label,
        YREFLECTION_ROPROPERTY(std::string, name)
        YREFLECTION_ROPROPERTY(std::string, creationTime)
        YREFLECTION_ROPROPERTY(std::string, color)
        YREFLECTION_ROPROPERTY(bool, isUser)
        YREFLECTION_ROPROPERTY(bool, isSystem)
        YREFLECTION_ROPROPERTY(macs::Label::Type, type)
        YREFLECTION_ROPROPERTY(macs::Label::Symbol, symbolicName)
        YREFLECTION_ROPROPERTY(std::size_t, messagesCount)
        YREFLECTION_ROPROPERTY(std::optional<std::size_t>, unreadMessagesCount)
)
