#pragma once

#include <macs/mime_part_factory.h>
#include <yamail/data/reflection/details/adt.h>
#include <boost/optional.hpp>
#include <map>

namespace hound {

using StidHidMimeParts = std::map<macs::Hid, macs::MimePart>;

struct RootMessagePart {
    macs::Stid stid;
    StidHidMimeParts mimeParts;
};

struct StidHidMessagePart {
    macs::Hid stidHid;
    macs::MimePart mimePart;
};

using StidHidMessageParts = std::map<macs::Hid, hound::StidHidMessagePart>;
using StidMessageParts = std::map<macs::Stid, StidHidMessageParts>;

struct MessageParts {
    RootMessagePart root;
    StidMessageParts other;
};

using Mimes = std::map<macs::Mid, MessageParts>;

Mimes makeMimes(macs::MidsWithMimes midStidMimeParts, macs::MidsWithMimes windatMidStidMimeParts);

} // namespace hound

#define MIME_PART_FACTORY_PROPERTY(TYPE, NAME) \
    (NAME, TYPE, TYPE, YREFLECTION_PROPERTY_GETTER(NAME), \
        obj = macs::MimePartFactory(std::move(obj)) \
            .offsetEnd(std::numeric_limits<std::size_t>::max()) \
            .NAME(std::move(val)).release())

YREFLECTION_ADAPT_ADT(macs::MimePart,
    MIME_PART_FACTORY_PROPERTY(std::string, hid)
    MIME_PART_FACTORY_PROPERTY(std::string, contentType)
    MIME_PART_FACTORY_PROPERTY(std::string, contentSubtype)
    MIME_PART_FACTORY_PROPERTY(std::string, boundary)
    MIME_PART_FACTORY_PROPERTY(std::string, name)
    MIME_PART_FACTORY_PROPERTY(std::string, charset)
    MIME_PART_FACTORY_PROPERTY(std::string, encoding)
    MIME_PART_FACTORY_PROPERTY(std::string, contentDisposition)
    MIME_PART_FACTORY_PROPERTY(std::string, fileName)
    MIME_PART_FACTORY_PROPERTY(std::string, cid)
    MIME_PART_FACTORY_PROPERTY(std::size_t, offsetBegin)
    MIME_PART_FACTORY_PROPERTY(std::size_t, offsetEnd)
)

#undef MIME_PART_FACTORY_PROPERTY

BOOST_FUSION_ADAPT_STRUCT(hound::RootMessagePart,
    (std::string, stid)
    (hound::StidHidMimeParts, mimeParts)
)

BOOST_FUSION_ADAPT_STRUCT(hound::StidHidMessagePart,
    (std::string, stidHid)
    (macs::MimePart, mimePart)
)

BOOST_FUSION_ADAPT_STRUCT(hound::MessageParts,
    (hound::RootMessagePart, root)
    (hound::StidMessageParts, other)
)
