// Copyright (c) 2017 Yandex LLC. All rights reserved.
// Use of this source code is governed by a MPL 2.0
// license that can be found in the LICENSE file.
// Author: Vladimir Skipor <skipor@yandex-team.ru>

package main

import (
	"math/rand"
	"net/http"
	"strings"
	"time"
)

var sortType = []string{"date", "lang", "position"}

type Ammo struct {
	Tag    string
	UID    string
	Tid1   string
	Tid2   string
	Tid3   string
	Mid1   string
	Mid2   string
	Mid3   string
	Caller string
}

type Payload struct {
	URI        string
	Assert     string
	Method     string
	Data       string
	Xrequestid string
}

func makeTimestamp() string {
	return time.Now().Format("15:04:05.000000")
}

func (g *Gun) makeReq(ammo *Ammo, payload *Payload) *http.Request {
	req, _ := http.NewRequest(payload.Method, strings.Join([]string{"http://", g.conf.Target, payload.URI}, ""), strings.NewReader(payload.Data))
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded")
	req.Header.Add("Connection", "keep-alive")
	req.Header.Add("X-Request-Id", payload.Xrequestid)
	return req
}

func (g *Gun) genPayload(ammo *Ammo) *Payload {
	payload := Payload{
		Method:     "GET",
		Xrequestid: makeTimestamp() + "_" + ammo.UID,
		Assert:     "^.\"error\":",
	}

	switch ammo.Tag {
	// -- new arms --
	case "attach_sid_v2":
		payload.URI = "/v2/attach_sid?uid=" + ammo.UID + "&mid=" + ammo.Mid1 + "&hids=1.1&hids=1.2"
	case "with_attaches_counters":
		payload.URI = "/v2/with_attaches_counters?uid=" + ammo.UID
	case "from_favorite_user_counter":
		payload.URI = "/v2/from_favorite_user_counter?uid=" + ammo.UID
	case "tabs":
		payload.URI = "/v2/tabs?uid=" + ammo.UID
	case "messages_by_tab":
		payload.URI = "/v2/messages_by_tab?uid=" + ammo.UID + "&tab=relevant&first=0&count=20"
	case "threads_by_tab":
		payload.URI = "/v2/threads_by_tab?uid=" + ammo.UID + "&tab=relevant&first=0&count=20"
	case "reset_tab_unvisited":
		payload.URI = "/v2/reset_tab_unvisited?uid=" + ammo.UID + "&tab=relevant"
	case "messages_unread_by_tab":
		payload.URI = "/v2/messages_unread_by_tab?uid=" + ammo.UID + "&tab=relevant&first=0&count=20"
	case "messages_in_tab_with_pins":
		payload.URI = "/v2/messages_in_tab_with_pins?uid=" + ammo.UID + "&tab=relevant&first=0&count=20"
	case "threads_in_tab_with_pins":
		payload.URI = "/v2/threads_in_tab_with_pins?uid=" + ammo.UID + "&tab=relevant&first=0&count=20"
	case "first_envelope_date_v2":
		payload.URI = "/v2/first_envelope_date?fid=1&uid=" + ammo.UID
	case "first_envelope_date_in_tab":
		payload.URI = "/v2/first_envelope_date_in_tab?tab=relevant&uid=" + ammo.UID
	case "filter_search":
		payload.URI = "/filter_search?uid=" + ammo.UID + "&order=date&fids=1&mids=" + ammo.Mid1 + "&mids=" + ammo.Mid2
	case "labels":
		payload.URI = "/labels?uid=" + ammo.UID
	case "counters":
		payload.URI = "/counters?caller=" + ammo.Caller + "&uid=" + ammo.UID
	case "yamail_status":
		payload.URI = "/yamail_status?uid=" + ammo.UID
	case "folders_v2_tree":
		payload.URI = "/v2/folders_tree?uid=" + ammo.UID + "&lang=ru&sort=" + sortType[rand.Intn(len(sortType))]
	case "folders_v2":
		payload.URI = "/v2/folders?uid=" + ammo.UID
	case "stickers":
		payload.URI = "/v2/stickers?uid=" + ammo.UID + "&type=reply_later"
	case "folders":
		payload.URI = "/folders?uid=" + ammo.UID
	case "messages_by_thread":
		payload.URI = "/messages_by_thread?uid=" + ammo.UID + "&page=1&count=50&tid=" + ammo.Tid1
	case "mimes":
		payload.URI = "/mimes?uid=" + ammo.UID + "&mid=" + ammo.Mid1
	case "mailbox_revision":
		payload.URI = "/mailbox_revision?uid=" + ammo.UID
	case "nearest_messages":
		payload.URI = "/nearest_messages?rawMessages=true&metaMethod=messages-nearest&deviation=1&mid=" + ammo.Mid1 + "&_count=30&first=0&count=31&uid=" + ammo.UID
	case "first_envelope_date":
		payload.URI = "/first_envelope_date?fid=1&uid=" + ammo.UID
	case "threads_info":
		payload.URI = "/threads_info?uid=" + ammo.UID + "&tid=" + ammo.Tid1 + "&tid=" + ammo.Tid2 + "&tid=" + ammo.Tid3
	case "messages_by_label":
		payload.URI = "/messages_by_label?rawMessages=true&metaMethod=messages_by_label&lid=1&_count=30&sort_type=date&count=31&first=0&uid=" + ammo.UID
	case "threads_by_folder":
		payload.URI = "/threads_by_folder?uid=" + ammo.UID + "&first=0&count=10&fid=1"
	case "messages_by_folder":
		payload.URI = "/messages_by_folder?uid=" + ammo.UID + "&first=0&count=20&fid=1&sort_type=date1"
	case "messages_in_folder_with_pins":
		payload.URI = "/messages_in_folder_with_pins?rawMessages=true&metaMethod=messages_in_folder_with_pins&fid=1&_count=30&count=31&first=0&uid=" + ammo.UID
	case "threads_in_folder_with_pins":
		payload.URI = "/threads_in_folder_with_pins?rawMessages=true&metaMethod=threads_in_folder_with_pins&fid=1&first=0&_count=30&count=31&uid=" + ammo.UID
	case "messages_unread_by_folder":
		payload.URI = "/messages_unread_by_folder?uid=" + ammo.UID + "&first=0&count=20&fid=1"
	case "messages_unread":
		payload.URI = "/messages_unread?uid=" + ammo.UID + "&first=0&count=20"
	case "messages_unread_useful":
		payload.URI = "/messages_unread_useful?uid=" + ammo.UID
	case "in_reply_to":
		payload.URI = "/in_reply_to?uid=" + ammo.UID + "&message_id=" + ammo.Mid1
	case "messages_with_attaches":
		payload.URI = "/messages_with_attaches?rawMessages=true&metaMethod=messages_with_attaches&_count=30&sort_type=date&first=0&count=31&uid=" + ammo.UID
	case "folders_counters":
		payload.URI = "/folders_counters?uid=" + ammo.UID
	case "attach_sid":
		payload.URI = "/attach_sid"
		payload.Data = `[{"uid":` + ammo.UID + `,"downloads":[{"mid": ` + ammo.Mid1 + `,"hids":["1.1"]},{"mid":` + ammo.Mid2 + `,"hids": ["1.2"]},{"mid": ` + ammo.Mid3 + `,"hids": ["1.1","1.2"]}]}]`
		payload.Method = "POST"
	default:
		payload.URI = "/ping"
		payload.Assert = ""
	}
	return &payload
}
