import sys
import random
import json
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--profile", type=str, help="string with json profile, in handler:weight format", default='{"folders": 95}')
parser.add_argument("--src", type=str, help="data source with ids from db", default='load/files/new.source')
parser.add_argument("--type", type=str, help="user type from data source", default='type500')
args = parser.parse_args()


def weighted_json_choice(choices):
    '''dict where key is choice and value probability'''
    total = sum(choices[choice] for choice in choices)
    r = random.uniform(0, total)
    upto = 0
    for choice in choices:
        if upto + choices[choice] >= r:
            return choice
        upto += choices[choice]


def dedup_str_list(str_list):
    out=[]
    for s in str_list:
        if not s in out:
            out.append(s)
    return out


def get_n_elements(str_list, num):
    indices = []
    out = []
    if len(str_list) < num:
        print("list < num")
        return None
    while len(indices) < num:
        i = random.randint(0,len(str_list)-1)
        if not i in indices:
            indices.append(i)
    for i in indices:
        out.append(str_list[i])
    return out


class Ammo(object):
    def __init__(self):
        self.output = []
        self.caller = ["wmi", "mobile"]
        self.legal_handlers = [
            "attach_sid",
            "attach_sid_v2",
            "counters",
            "from_favorite_user_counter",
            "filter_search",
            "first_envelope_date",
            "first_envelope_date_v2",
            "first_envelope_date_in_tab",
            "stickers",
            "folders",
            "folders_counters",
            "folders_v2",
            "folders_v2_tree",
            "in_reply_to",
            "labels",
            "mailbox_revision",
            "messages_by_folder",
            "messages_by_label",
            "messages_by_tab",
            "messages_by_thread",
            "messages_in_folder_with_pins",
            "messages_in_tab_with_pins",
            "messages_unread",
            "messages_unread_by_folder",
            "messages_unread_by_tab",
            "messages_unread_useful",
            "messages_with_attaches",
            "mimes",
            "nearest_messages",
            "ping",
            "reset_tab_unvisited",
            "short_fresh_message",
            "tabs",
            "threads_by_folder",
            "threads_by_tab",
            "threads_in_folder_with_pins",
            "threads_in_tab_with_pins",
            "threads_info",
            "with_attaches_counters",
            "yamail_status"
        ]
        self.meta = self.meta_parser(args.src)
        self.distr = self.set_distr_from_json(args.profile)

    def meta_parser(self, filename):
        out = []
        with open(filename, "r") as fd:
            for line in fd:
                t1, login, mids, fids, tids, stids, lids, uid, suid, md5, mdb = line.rstrip()[1:-1].split('","')
                if t1 == args.type:
                    out.append({"type": t1, "login" : login, "mids": mids.split(','), "fid": "1", "tids": dedup_str_list(tids.split(',')), "stids": stids.split(','), "lids": lids.split(','), "uid": uid, "suid": suid, "md5": md5, "mdb": mdb})
        return out

    def set_distr_from_json(self, input_json):
        profile = json.loads(input_json.replace(" ", "").replace("\n", ""))
        self.check_profile(profile)
        out = []
        for i in xrange(400000):
            out.append(weighted_json_choice(profile))
        return out

    def check_profile(self, profile):
        inlegal = []
        status = True
        if type(profile) == dict:
            for handler in profile.keys():
                if handler in self.legal_handlers:
                    pass
                else:
                    status = False
                    inlegal.append(handler)
        else:
            raise Exception("Wrong profile")
        if status == False:
            raise Exception("Handlers {} are inlegal".format(", ".join(inlegal)))

    def make_ammo(self):
        i = 0
        with open("./ammo.json", "w") as fd:
            for handler in self.distr:
                mid1, mid2, mid3 = get_n_elements(self.meta[i%len(self.meta)]["mids"], 3)
                tid1, tid2, tid3 = get_n_elements(self.meta[i%len(self.meta)]["tids"], 3)
                out = '{"tag": "' + handler + '", "uid": "' + self.meta[i%len(self.meta)]["uid"] + '", "tid1": "' + tid1 + '", "tid2": "' + tid2 + '", "tid3": "' + tid3 + '", "mid1": "' + mid1 + '", "mid2": "' + mid2 + '", "mid3": "' + mid3 + '", "caller": "' + random.choice(self.caller) + '"}'
                if handler in self.legal_handlers:
                    fd.write(out+"\n")
                i += 1


if __name__ == "__main__":
    meta = []
    handlers= []
    ammo = Ammo()
    if len(ammo.meta) == 0:
        sys.stderr.write('no users with type: ' + args.type + '\n')
        sys.exit(1)
    else:
        ammo.make_ammo()
