#!/usr/bin/env /usr/bin/python
import requests
import json
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--post", type=str, help="Post shoot comment")
parser.add_argument("--ticket", type=str, help="Ticket number for comment")
parser.add_argument("--regress", type=str, help="Regression comment")
args = parser.parse_args()
Ticket = args.ticket
PostShoot = args.post
Regress = args.regress
Comment = ''
Header = u'\u0420\u0435\u0433\u0440\u0435\u0441\u0441\u0438\u044f'
Footer = u'\u041e\u0446\u0435\u043d\u043a\u0430 \u0434\u0438\u0441\u043f\u0435\u0440\u0441\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0441\u0442\u0440\u0435\u043b\u044c\u0431\u044b \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u043c\u0435\u0434\u0438\u0430\u043d\u044b \u044d\u0442\u0430\u043b\u043e\u043d\u043d\u043e\u0439 \u0432\u044b\u0431\u043e\u0440\u043a\u0438' 
good_result = u'\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430' 
bad_result = u'\u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043e\u0448\u0438\u0431\u043a\u0438'
regress_result = Regress.split("\n")[-1]
regress_body = "\n".join(Regress.split("\n")[:-1])
if Ticket != None:
#
    with open("/var/bmpt/lunapark/oauth_startrek.token", "r") as oauth:
        benderAuth = oauth.readline().replace("\n","")
#
    with open(PostShoot, "r") as ps:
        for line in ps:
            Comment += line
    Comment += "<{%s\n#|\n||%s||\n|#\n%s}>\n%s"%(Header.encode('utf-8'), 
                regress_body.replace("\n","||\n||").replace("passed","!!(green)passed!!").replace("failed","!!(red)failed!!").replace("improved","!!(yellow)improved!!"),
                Footer.encode('utf-8'), regress_result.replace("passed","**!!(green)" + good_result.encode('utf-8') + "!!**").replace("failed","**!!(red)" + bad_result.encode('utf-8') + "!!**"))
    Headers = {"Authorization": "OAuth %s"%(benderAuth), "Content-Type":"application/json"} 
    URL = "https://st-api.yandex-team.ru"
    DATA = {"text":Comment}
    tickets = Ticket.split(" ")
    for ticket in tickets:
        URI = "/v2/issues/{!s}/comments".format(ticket)
        try:
            session = requests.Session()
            result = session.post(url=URL+URI, headers=Headers, data=json.dumps(DATA), verify=False)
            print(result.json())
        except Exception as ex:
            print(ex)
        finally:
            session.close()
else:
    print("Unknown ticket")
