import sys
import argparse

if __name__ == "__main__":
    uids = []
    parser = argparse.ArgumentParser()
    parser.add_argument("--bases", type=int, help="number of bases you need to generate", default=50)
    args = parser.parse_args()

    with open('../files/uid.csv', 'r') as fd:
        uids = fd.read().rstrip().split(',')

    bases = args.bases + 1
    start = 1
    with open('sharpei.lua', 'w') as fd:
        fd.write('local args = ngx.req.get_uri_args()\nlocal uid_hashmap = {\n')
        for uid in uids:
            if start % (bases) == 0:
                start += 1
            fd.write("    ['%s'] = \"%02d\",\n" % (uid, start % (bases)))
            start += 1
        fd.write('}\n\n')
        fd.write("alias = (tonumber(args['uid']) % 50) + 1\n")
        fd.write("ngx.header.content_type = 'application/json; charset=UTF-8'\n")
        fd.write("ngx.say('{\"id\":1,\"name\":\"load001\",\"databases\":[{\"address\":{\"host\":\"alias'..alias..'.man-arc5izadywspu1dq.db.yandex.net\",\"port\":6432,\"dbname\":\"maildb\",\"dataCenter\":\"MAN\"},\"role\":\"replica\",\"status\":\"alive\",\"state\":{\"lag\":0}},{\"address\":{\"host\":\"alias'..alias..'.sas-w0ckruj66882d0hz.db.yandex.net\",\"port\":6432,\"dbname\":\"maildb\",\"dataCenter\":\"SAS\"},\"role\":\"replica\",\"status\":\"alive\",\"state\":{\"lag\":0}},{\"address\":{\"host\":\"alias'..alias..'.vla-s8vr9k65cww07cb5.db.yandex.net\",\"port\":6432,\"dbname\":\"maildb\",\"dataCenter\":\"VLA\"},\"role\":\"master\",\"status\":\"alive\",\"state\":{\"lag\":0}}]}')\n")
        fd.write('ngx.exit(200)')

    start = 1
    with open('hosts', 'w') as fd:
        fd.write('::1     localhost localhost.localdomain localhost6 localhost6.localdomain6\n127.0.0.1       localhost localhost.localdomain localhost4 localhost4.localdomain4\n\n')
        for i in range(bases-1):
            fd.write('2a02:6b8:c1a:2838:0:1589:9203:72e9 man-arc5izadywspu1dq.db.yandex.net\n' % (start % bases))
            fd.write('2a02:6b8:c14:4c90::1589:5606:a27b sas-w0ckruj66882d0hz.db.yandex.net\n' % (start % bases))
            fd.write('2a02:6b8:c0f:9b::1589:bab1:21b7 vla-s8vr9k65cww07cb5.db.yandex.net\n' % (start % bases))
            start += 1
