#include <mail/hound/include/internal/config.h>
#include <mail/webmail/mulcagate_client/mulca_client.h>
#include <mail_getter/mulcagate/integration.h>
#include <mail_getter/attach_sid_keys.h>
#include <yamail/data/deserialization/ptree.h>
#include <mail/http_getter/client/include/endpoint_reflection.h>


namespace {

hound::Config::ServicesDbUsers initServicesDbUsers(const yplatform::ptree& tree, const hound::ModuleLogger& logger) {
    const auto servicesDbUsersTree = tree.get_child_optional("pg.services_db_users");

    hound::Config::ServicesDbUsers servicesDbUsers;
    if (servicesDbUsersTree.is_initialized()) {
        for (const auto& service : servicesDbUsersTree.get()) {
            servicesDbUsers[service.first] = service.second.data();
        }
    } else {
        const auto methodName = __PRETTY_FUNCTION__;
        LOGDOG_(logger, notice, hound::log::where_name=methodName,
                hound::log::message="config doesn't contain service_db_users");
    }

    return servicesDbUsers;
}

hound::RecognizerConfig initRecognizer(const yplatform::ptree& tree) {
    hound::RecognizerConfig recognizer;
    recognizer.languageDict = tree.get<std::string>("recognizer.language_dict");
    recognizer.languageWeights = tree.get<std::string>("recognizer.language_weights");
    recognizer.encodingDict = tree.get<std::string>("recognizer.encoding_dict");
    return recognizer;
}


}

namespace hound {

using namespace mail_getter;

Config::Config(const yplatform::ptree& cfg, http_getter::TypedModulePtr http)
    : itemsPerPage_(cfg.get<unsigned int>("items_per_page"))
    , servicesDbUsers_(initServicesDbUsers(cfg, getModuleLogger()))
    , countersLimit_(cfg.get<std::size_t>("counters_limit"))
    , mailboxLimit_(cfg.get<std::size_t>("mailbox_limit"))
    , tidsLimit_(cfg.get<std::size_t>("tids_limit"))
    , coroutineStackSize_(cfg.get<std::size_t>("coroutine_stack_size", 1048576))
    , recognizer_(initRecognizer(cfg))
    , keys_(attach_sid::initKeys(cfg.get_child("attach_sid_keys"), attach_sid::parseKeyContainer(cfg.get_child("attach_sid_keys"))))
    , passportEndpoint_(http_getter::TypedEndpoint::fromPtree(cfg.get_child("passport")))
    , http_(std::move(http))
    , maildb_(yplatform::find<ymod_maildb::Module, std::shared_ptr>("maildb"))
{
    mailStorage_ = mail_getter::initMailStorage(cfg.get_child("mulcagate"), http_);
}

ConfigPtr makeConfig(const yplatform::ptree& cfg, http_getter::TypedModulePtr http) {
    return std::make_shared<Config>(cfg, std::move(http));
}

}
