#include <mail/hound/include/internal/wmi/meta_access/metadata_helpers.h>

#include <boost/range/algorithm/copy.hpp>
#include <boost/range/adaptor/filtered.hpp>
#include <boost/range/adaptor/map.hpp>

namespace hound::helpers {

using namespace boost::adaptors;

void filterFoldersWithSymbols(const macs::FolderSet& folders,
        const std::list<macs::Folder::Symbol>& symbols, macs::FidList& fids) {

    fids.remove_if(
            [&]( const std::string& fid ) {
                const auto & symb = folders.at( fid ).symbolicName();
                return std::find(symbols.begin(), symbols.end(), symb) == symbols.end();
            }
    );
}

void filterFoldersWithoutSymbols(const macs::FolderSet& folders,
        const std::list<macs::Folder::Symbol>& symbols, macs::FidList& fids) {

    fids.remove_if(
            [&]( const std::string& fid ) {
                const auto & symb = folders.at( fid ).symbolicName();
                return std::find(symbols.begin(), symbols.end(), symb) != symbols.end();
            }
    );
}

void filterUsefulFolders(const macs::FolderSet& folders, macs::FidList& fids) {
    filterFoldersWithSymbols(folders,
            {macs::Folder::Symbol::inbox, macs::Folder::Symbol::none}, fids);
}

void filterUnreadFolders(const macs::FolderSet& folders, macs::FidList& fids) {
    fids.remove_if(
            [&]( const std::string& fid ) {
                return folders.at( fid ).newMessagesCount() == 0;
            }
    );
}

macs::FidList getUnreadUsefulFolders(const macs::FolderSet& folders) {
    macs::FidList fids;
    boost::copy(folders | map_keys, std::back_inserter(fids));

    filterUsefulFolders(folders, fids);
    filterUnreadFolders(folders, fids);

    return fids;
}

}



