#include <mail/hound/include/internal/server/base.h>
#include <mail/hound/include/internal/wmi/errors.h>

namespace hound::server {

void Base::process(const ymod_webserver::http::stream_ptr& stream, boost::asio::yield_context yield) {
    if (!isAccepted(stream->request()->method)) {
        stream->result(ymod_webserver::codes::method_not_allowed);
        return;
    }

    auto ctx = std::make_shared<Context>(stream);
    try {
        execute(ctx, yield);
    } catch (...) {
        ctx->responseErrorOnException();
    }
}

}
