#include <mail/hound/include/internal/wmi/service/passport.h>

#include <mail/http_getter/client/include/fmt.h>
#include <io_result/io_result.h>
#include <yamail/data/deserialization/json_reader.h>

namespace hound {

PassportResponse passportUnfreeze(const http_getter::TypedClientPtr& client, const http_getter::TypedEndpoint& passportEndpoint,
                                    const std::string& uid, boost::asio::yield_context yield) {
    auto endpoint = passportEndpoint.format(fmt::arg("uid", uid));
    auto requestBuilder = client->toPOST(endpoint)
            .body(yhttp::form_encode({ {"is_mailbox_frozen", "no"} }));

    PassportResponse result = {.errors = std::vector<std::string>{"can't get response from passport"}};
    client
        ->req(requestBuilder)
        ->call("passport", [&result](yhttp::response resp) {
            try {
                if (http_getter::helpers::retriableCode(resp.status)) {
                    result.httpCode = resp.status;
                    return http_getter::Result::retry;
                }
                result = yamail::data::deserialization::fromJson<PassportResponse>(resp.body);
                result.httpCode = resp.status;
                if (!result.hasError()) {
                    return http_getter::Result::success;
                } else if (result.hasOnlyRetriableErrors()) {
                    return http_getter::Result::retry;
                }
                return http_getter::Result::fail;
            } catch(const std::exception& e) {
                result.errors->emplace_back(e.what());
                return http_getter::Result::fail;
            } catch (const boost::coroutines::detail::forced_unwind&) {
                throw;
            } catch(...) {
                result.errors->emplace_back("unexpected exception type");
                return http_getter::Result::fail;
            }
        }, io_result::make_yield_context(yield));

    return result;
}

} // namespace hound
